:- auto_table.
:- import h/1,c/1,molecule/1,single/2,double/2,triple/2,hasAtom/2,cycle/0 from molecules30.

bond(X,Y) :- single(X,Y).
bond(X,Y) :- double(X,Y).
bond(X,Y) :- triple(X,Y).

hasBenzeneRing(X) :- molecule(X), hasAtom(X,Y1), c(Y1),  hasAtom(X,Y2), c(Y2), single(Y1,Y2), single(Y2,Y1), hasAtom(X,Y3), c(Y3), double(Y2,Y3), double(Y3,Y2), hasAtom(X,Y4), c(Y4), single(Y3,Y4), single(Y4,Y3), hasAtom(X,Y5), double(Y4,Y5), double(Y5,Y4), c(Y5), hasAtom(X,Y6), c(Y6), single(Y5,Y6), single(Y6,Y5), double(Y6,Y1), double(Y1,Y6).

hasFourMemberedRing(X) :- molecule(X), hasAtom(X,Y1), hasAtom(X,Y2), (Y1) \== (Y2), bond(Y1,Y2), bond(Y2,Y1), hasAtom(X,Y3), (Y1) \== (Y3),  (Y2) \== (Y3), bond(Y2,Y3), bond(Y3,Y2), hasAtom(X,Y4), (Y1) \== (Y4), (Y2) \== (Y4), (Y3) \== (Y4), bond(Y3,Y4), bond(Y4,Y3), bond(Y4,Y1), bond(Y1,Y4).

notHydroCarbon(X) :- hasAtom(X,Y), tnot(c(Y)), tnot(h(Y)).
hydroCarbon(X) :- molecule(X), tnot(notHydroCarbon(X)).

molWithCarbon(X) :- hasAtom(X, Y), c(Y).
inorganic(X) :- molecule(X), tnot(molWithCarbon(X)).

atLeast2Carbons(X) :- molecule(X), hasAtom(X,Y1), c(Y1), hasAtom(X,Y2), c(Y2), Y1 \== Y2.
atLeast3Carbons(X) :- molecule(X), hasAtom(X,Y1), c(Y1), hasAtom(X,Y2), c(Y2), Y1 \== Y2, hasAtom(X,Y3), c(Y3), Y1 \== Y3, Y2 \== Y3.
biCarbon(X) :- atLeast2Carbons(X), tnot(atLeast3Carbons(X)).

:-write('****************************************************************'),nl.
:-write('Results for 30 molecules'),nl.

:-write('======================================================'),nl,write('Is cycle derived?').
:-cycle, write(' yes').
:-tnot(cycle), write(' no').
:-nl,write('======================================================'),nl.

:-qHC.
qHC :- cputime(T1), qHCNested, cputime(T2), T is T2 - T1,write('Time used: '),  write(T), write(' sec'), nl.

qHCNested :- nl,write('Hydrocarbons:'),nl,abolish_all_tables, hydroCarbon(X), write(X), nl, fail.
qHCNested.

:-qInorganic.
qInorganic :- cputime(T1), qInorganicNested, cputime(T2), T is T2 - T1,write('Time used: '),  write(T), write(' sec'), nl.

qInorganicNested :- nl,write('Inorganic molecules:'),nl,abolish_all_tables, inorganic(X), write(X), nl, fail.
qInorganicNested.

:-qBiC.
qBiC :- cputime(T1), qBiCNested, cputime(T2), T is T2 - T1,write('Time used: '),  write(T), write(' sec'), nl.

qBiCNested :- nl,write('Molecules with exactly two carbons:'),nl,abolish_all_tables, biCarbon(X), write(X), nl, fail.
qBiCNested.

:-q4MR.
q4MR :- cputime(T1), q4MRNested, cputime(T2), T is T2 - T1,write('Time used: '),  write(T), write(' sec'), nl.

q4MRNested :- nl,write('Molecules with a four membered ring:'),nl,abolish_all_tables, hasFourMemberedRing(X), write(X), nl, fail.
q4MRNested.

:-qBR.
qBR :- cputime(T1), qBRNested, cputime(T2), T is T2 - T1,write('Time used: '),  write(T), write(' sec'), nl.

qBRNested :- nl,write('Molecules with a benzene ring:'),nl,abolish_all_tables, hasBenzeneRing(X), write(X), nl, fail.
qBRNested.
