package uk.ac.ox.cs.krr.chebiclassifier;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class ChEBIClassifier {
	
	public static String m_inputFilesPath;
	public static int m_maxMolfiles;

	//produce a .P file which contains all the LP rules for the
	//.mol files that are found in the m_inputFilesPath
	public static void main(String[] args) {
		try{
			m_inputFilesPath="input/seventy";
			m_maxMolfiles=70;
			File molfilesFolder = new File(m_inputFilesPath);
			File[] list = molfilesFolder.listFiles();
			ArrayList<File> molFilesToTest=new ArrayList<File>();
			
			//Filter mol files
			for (File file : list) {
				if ((file.getName()).endsWith("mol")) {
					if ((file.getName()).endsWith("_17997.mol")){
						molFilesToTest.add(0,file);						
					}
					else{
						molFilesToTest.add(file);
					}					
				}
			}
			
			DGGenerator dgGenerator=new DGGenerator();
			Set<XSBRule> outputXSBRules=new LinkedHashSet<XSBRule>();	
			XSBRulesGenerator xsbRulesGenerator=new XSBRulesGenerator();
			
			for (int i=10; i<=m_maxMolfiles; i+=10){
				ArrayList<DescriptionGraph> dgsToTest=new ArrayList<DescriptionGraph>();
				for (int j=0; j<i; j++){
					File molfile=molFilesToTest.get(j);
					DescriptionGraph descriptionGraph=dgGenerator.buildDescriptionGraph(molfile);
					dgsToTest.add(descriptionGraph);
					outputXSBRules.addAll(xsbRulesGenerator.produceAxiomRules(descriptionGraph));
				}
				
				outputXSBRules.addAll(xsbRulesGenerator.produceCycleDetectionRules(dgsToTest,
						new GraphOrdering()));
	
				String fileName ="output/molecules"+i+".P";
				System.out.println("Creating file "+fileName+"...");
				File results = new File(fileName);
				results.createNewFile();
				FileWriter fStream = new FileWriter(results);
				BufferedWriter outputLogicProgram = new BufferedWriter(fStream);
				String CRLF=System.getProperty("line.separator");  
				outputLogicProgram.append(prologHeaders());
				for (XSBRule rule:outputXSBRules){
					outputLogicProgram.append(rule.getXSBSyntaxRule());
					outputLogicProgram.append(CRLF);
				}
				outputLogicProgram.close();
				outputXSBRules.removeAll(outputXSBRules);
				System.out.println("File "+fileName+" created.");
			}
			
			QueriesGenerator qg=new QueriesGenerator(10,m_maxMolfiles,10);
			qg.produceQueriesFiles();
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
	
	public static String prologHeaders(){
		StringBuffer sb=new StringBuffer();
		String CRLF=System.getProperty("line.separator");
		sb.append(":- auto_table.");
		sb.append(CRLF);
		sb.append(":- export h/1,c/1,molecule/1,single/2,double/2,triple/2,hasAtom/2,cycle/0.");
		sb.append(CRLF);
		sb.append(":- table h/1,c/1,cycle/0.");
		sb.append(CRLF);
		sb.append(CRLF);
		return sb.toString();
	}
}
