package uk.ac.ox.cs.krr.chebiclassifier;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DescriptionGraph {
	//private Set<Integer> m_nodes;
	private Map<Integer,String> m_nodes;
	private Set<Edge> m_edges;
	private String m_startConcept;
	
	public DescriptionGraph(Map<Integer,String> nodes,Set<Edge> edges,String startConcept){
		this.m_nodes=nodes;
		this.m_edges=edges;
		this.m_startConcept=startConcept;
	}
	
	public Map<Integer,String> getNodes(){
		return this.m_nodes;
	}
	
	public Set<Edge> getEdges(){
		return this.m_edges;
	}
	
	public String getStartConcept(){
		return this.m_startConcept;
	}
	
	//it produces a rule of the form chebi_12345(X) -> g_chebi_12345(X)
	public XSBRule produceStartRule(){
		Atom headAtom=produceGraphAtom(true);;
	    ArrayList<Atom> bodyAtoms=new ArrayList<Atom>();
	    bodyAtoms.add(produceStartAtom("X"));
		return new XSBRule(headAtom,bodyAtoms);
	}
	
	//it clears the content of a buffer
	public StringBuffer clearBuffer(StringBuffer sb){
		return sb.delete(0,sb.length());
	}
	
	//it produces a set of rules of the form g_chebi_12345(Y0,Y1,Y2) -> hasAtom(Y0,Y1)
	public Set<XSBRule> produceLayoutRules(){
		Set<XSBRule> rules=new LinkedHashSet<XSBRule>();
		StringBuffer sb=new StringBuffer();
		
	    ArrayList<Atom> bodyAtoms=new ArrayList<Atom>();
	    bodyAtoms.add(produceGraphAtom(false));
	    
	    for (int i=1; i<m_nodes.size(); i++){
	    	ArrayList<String> headAtomTerms=new ArrayList<String>();
	        sb.append('Y');
	        sb.append(i);
	        headAtomTerms.add(sb.toString());
	        clearBuffer(sb);
	    	Atom headAtom=new Atom(m_nodes.get(new Integer(i)),headAtomTerms);
	    	rules.add(new XSBRule(headAtom,bodyAtoms));
	    }	    
	    
	    for (Edge edge:m_edges){
	    	ArrayList<String> headAtomTerms=new ArrayList<String>();
	        sb.append('Y');
	        sb.append(edge.getFromNode());
	        headAtomTerms.add(sb.toString());
	        clearBuffer(sb);
	        sb.append('Y');
	        sb.append(edge.getToNode());
	        headAtomTerms.add(sb.toString());
	        clearBuffer(sb);
	        Atom headAtom=new Atom(edge.getLabel(),headAtomTerms);
	    	rules.add(new XSBRule(headAtom,bodyAtoms));
	    }	    
	   return rules;
	}
	
	//it produces an atom of the form chebi_12345(variable)
	public Atom produceStartAtom(String variable){
		ArrayList<String> bodyAtomTerms=new ArrayList<String>();
	    bodyAtomTerms.add(variable);    
	    return new Atom(m_startConcept,bodyAtomTerms);
	    
	}
	
	//it produces an atom of the form g_chebi_12345(Y0,Y1,Y2) or
	//g_chebi_12345(X,f1(X),f2(X)) depending on the flag
	public Atom produceGraphAtom(boolean functionTermsOn){
		StringBuffer sb=new StringBuffer();
	    sb.append("g_");
	    sb.append(m_startConcept);
	    String predicate=sb.toString();
	    clearBuffer(sb);
	    ArrayList<String> terms=new ArrayList<String>();
	    if (functionTermsOn){
	    	terms.add("X");
	    }
	    else {
	    	terms.add("Y0");
	    }
	        
	    for (int i=1; i<m_nodes.size(); i++){
	    	if (functionTermsOn){
	    		sb.append("f_");
		    	sb.append(m_startConcept);
		    	sb.append("_");
		    	sb.append(i);
		    	sb.append("(X)");
	    	}
	    	else {
	    		sb.append("Y");
		    	sb.append(i);
	    	}
	    	terms.add(sb.toString());
	    	clearBuffer(sb);
	    }
	    return new Atom(predicate,terms);
	}
	
	//it produces a rule of the form chebi_12345(X) -> molecule(X)
	public XSBRule produceMoleculeRule(){
		ArrayList<String> headAtomTerms=new ArrayList<String>();
		headAtomTerms.add("X");
		Atom headAtom=new Atom("molecule",headAtomTerms);
		ArrayList<Atom> bodyAtoms=new ArrayList<Atom>();
		bodyAtoms.add(produceStartAtom("X"));	
		return new XSBRule(headAtom,bodyAtoms);
	}
	
	//it produces a fact of the form chebi_12345(c_chebi_12345)	
	public XSBRule produceMoleculeFact(){
		StringBuffer sb=new StringBuffer();
		ArrayList<String> headAtomTerms=new ArrayList<String>();
		sb.append("c_");
		sb.append(m_startConcept);
		headAtomTerms.add(sb.toString());
		Atom headAtom=new Atom(m_startConcept,headAtomTerms);
	    ArrayList<Atom> bodyAtoms=new ArrayList<Atom>();
		return new XSBRule(headAtom,bodyAtoms);
	}
	
	//it produces the cycle detection rules
	public Set<XSBRule> produceSelfCycleDetectionRules(){
		Set<XSBRule> rules=new LinkedHashSet<XSBRule>();
		StringBuffer sb=new StringBuffer();
		ArrayList<String> headAtomTerms=new ArrayList<String>();
		Atom headAtom=new Atom("cycle",headAtomTerms);
		
		for (int i=1; i<m_nodes.size(); i++){
			ArrayList<Atom> bodyAtoms=new ArrayList<Atom>();
			bodyAtoms.add(produceGraphAtom(false));
			sb.append("Y");
			sb.append(i);
			bodyAtoms.add(produceStartAtom(sb.toString()));
	    	clearBuffer(sb);
	    	rules.add(new XSBRule(headAtom,bodyAtoms));
	    }
		
		return rules;
		
	}
	
	//it returns a string which fully describes the description graph
	public String getTextRepresentation(){
		StringBuffer buffer=new StringBuffer();
        String CRLF=System.getProperty("line.separator");
        buffer.append('[');
        buffer.append(CRLF);
        buffer.append("Nodes");
        buffer.append(CRLF);
        buffer.append("--------------------");
        buffer.append(CRLF);
        Set<Integer> nodeNumbers=m_nodes.keySet();
        for (Integer nodeNumber:nodeNumbers) {
            buffer.append("   ");
            buffer.append(nodeNumber);
            buffer.append(" : ");
            buffer.append(m_nodes.get(nodeNumber));
            buffer.append(CRLF);
        }
        buffer.append(CRLF);
        buffer.append("Edges");
        buffer.append(CRLF);
        buffer.append("--------------------");
        buffer.append(CRLF);
        for (Edge edge : m_edges) {
            buffer.append("  ");
            buffer.append(edge.getFromNode());
            buffer.append(" --> ");
            buffer.append(edge.getToNode());
            buffer.append(" : ");
            buffer.append(edge.getLabel());
            buffer.append(CRLF);
        }
        buffer.append(CRLF);
        buffer.append("Start Concept");
        buffer.append(CRLF);
        buffer.append("--------------------");
        buffer.append(CRLF);
        buffer.append(m_startConcept);
        buffer.append(']');
        
        return buffer.toString();
	}
	
}
