package uk.ac.ox.cs.krr.chebiclassifier;

public class Pair<L, R> {
	
	private final L left;
    private final R right;

	  public Pair(L left, R right) {
	    this.left = left;
	    this.right = right;
	  }

	  public L getLeft() { return left; }
	  public R getRight() { return right; }

	  public int hashCode() { return left.hashCode() ^ right.hashCode(); }

	  @SuppressWarnings("unchecked")
	  public boolean equals(Object o) {
	    if (o == null) return false;
	    if (!(o instanceof Pair)) return false;
	    Pair<L,R> pairo = (Pair) o;
	    return this.left.equals(pairo.getLeft()) &&
	           this.right.equals(pairo.getRight());
	  }


}
