package uk.ac.ox.cs.krr.chebiclassifier;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

public class QueriesGenerator {
	int m_minNumber;
	int m_maxNumber;
	int m_step;
	
	public QueriesGenerator(int minNumber,int maxNumber,int step){
		m_minNumber=minNumber;
		m_maxNumber=maxNumber;
		m_step=step;
	}
	
	public void produceQueriesFiles(){
		try{
			for (int i=m_minNumber; i<=m_maxNumber; i+=m_step){
				String fileName ="output/queries"+i+".P";
				File results = new File(fileName);
				results.createNewFile();
				FileWriter fStream = new FileWriter(results);
				BufferedWriter outputLogicProgram = new BufferedWriter(fStream);
				outputLogicProgram.append(buildQueries(i));
				outputLogicProgram.close();
			}
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
	
	private String buildQueries(int numberOfMolecules){
		StringBuffer sb=new StringBuffer();
		String CRLF=System.getProperty("line.separator");
		sb.append(":- auto_table.");
		sb.append(CRLF);
		sb.append(":- import h/1,c/1,molecule/1,single/2,double/2,triple/2,hasAtom/2,cycle/0 from molecules");
		sb.append(numberOfMolecules);
		sb.append(".");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append("bond(X,Y) :- single(X,Y).");
		sb.append(CRLF);
		sb.append("bond(X,Y) :- double(X,Y).");
		sb.append(CRLF);
		sb.append("bond(X,Y) :- triple(X,Y).");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append("hasBenzeneRing(X) :- molecule(X), hasAtom(X,Y1), c(Y1),  hasAtom(X,Y2), " +
				"c(Y2), single(Y1,Y2), single(Y2,Y1), hasAtom(X,Y3), c(Y3), double(Y2,Y3), " +
				"double(Y3,Y2), hasAtom(X,Y4), c(Y4), single(Y3,Y4), single(Y4,Y3), hasAtom(X,Y5), " +
				"double(Y4,Y5), double(Y5,Y4), c(Y5), hasAtom(X,Y6), c(Y6), single(Y5,Y6), single(Y6,Y5), " +
				"double(Y6,Y1), double(Y1,Y6).");
		sb.append(CRLF);
		sb.append(CRLF);

		sb.append("hasFourMemberedRing(X) :- molecule(X), hasAtom(X,Y1), hasAtom(X,Y2), (Y1) \\== (Y2), " +
				"bond(Y1,Y2), bond(Y2,Y1), hasAtom(X,Y3), (Y1) \\== (Y3),  (Y2) \\== (Y3), bond(Y2,Y3), " +
				"bond(Y3,Y2), hasAtom(X,Y4), (Y1) \\== (Y4), (Y2) \\== (Y4), (Y3) \\== (Y4), bond(Y3,Y4), " +
				"bond(Y4,Y3), bond(Y4,Y1), bond(Y1,Y4).");
		sb.append(CRLF);
		sb.append(CRLF);

		sb.append("notHydroCarbon(X) :- hasAtom(X,Y), tnot(c(Y)), tnot(h(Y)).");
		sb.append(CRLF);
		sb.append("hydroCarbon(X) :- molecule(X), tnot(notHydroCarbon(X)).");
		sb.append(CRLF);
		sb.append(CRLF);

		sb.append("molWithCarbon(X) :- hasAtom(X, Y), c(Y).");
		sb.append(CRLF);
		sb.append("inorganic(X) :- molecule(X), tnot(molWithCarbon(X)).");
		sb.append(CRLF);
		sb.append(CRLF);

		sb.append("atLeast2Carbons(X) :- molecule(X), hasAtom(X,Y1), c(Y1), hasAtom(X,Y2), c(Y2), Y1 \\== Y2.");
		sb.append(CRLF);
		sb.append("atLeast3Carbons(X) :- molecule(X), hasAtom(X,Y1), c(Y1), hasAtom(X,Y2), c(Y2), Y1 \\== Y2, " +
				"hasAtom(X,Y3), c(Y3), Y1 \\== Y3, Y2 \\== Y3.");
		sb.append(CRLF);
		sb.append("biCarbon(X) :- atLeast2Carbons(X), tnot(atLeast3Carbons(X)).");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append(":-write('****************************************************************'),nl.");
		sb.append(CRLF);
		sb.append(":-write('Results for ");
		sb.append(numberOfMolecules);
		sb.append(" molecules'),nl.");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append(":-write('======================================================'),nl,write('Is cycle derived?').");
		sb.append(CRLF);
		sb.append(":-cycle, write(' yes').");
		sb.append(CRLF);
		sb.append(":-tnot(cycle), write(' no').");
		sb.append(CRLF);
		sb.append(":-nl,write('======================================================'),nl.");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append(":-qHC.");
		sb.append(CRLF);
		sb.append("qHC :- cputime(T1), qHCNested, cputime(T2), T is T2 - T1," +
				"write('Time used: '),  write(T), write(' sec'), nl.");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append("qHCNested :- nl,write('Hydrocarbons:'),nl,abolish_all_tables, hydroCarbon(X), write(X), nl, fail.");
		sb.append(CRLF);
		sb.append("qHCNested.");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append(":-qInorganic.");
		sb.append(CRLF);
		sb.append("qInorganic :- cputime(T1), qInorganicNested, cputime(T2), T is T2 - T1," +
				"write('Time used: '),  write(T), write(' sec'), nl.");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append("qInorganicNested :- nl,write('Inorganic molecules:'),nl,abolish_all_tables, " +
				"inorganic(X), write(X), nl, fail.");
		sb.append(CRLF);
		sb.append("qInorganicNested.");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append(":-qBiC.");
		sb.append(CRLF);
		sb.append("qBiC :- cputime(T1), qBiCNested, cputime(T2), T is T2 - T1," +
				"write('Time used: '),  write(T), write(' sec'), nl.");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append("qBiCNested :- nl,write('Molecules with exactly two carbons:'),nl,abolish_all_tables, " +
				"biCarbon(X), write(X), nl, fail.");
		sb.append(CRLF);
		sb.append("qBiCNested.");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append(":-q4MR.");
		sb.append(CRLF);
		sb.append("q4MR :- cputime(T1), q4MRNested, cputime(T2), T is T2 - T1," +
				"write('Time used: '),  write(T), write(' sec'), nl.");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append("q4MRNested :- nl,write('Molecules with a four membered ring:'),nl,abolish_all_tables, " +
				"hasFourMemberedRing(X), write(X), nl, fail.");
		sb.append(CRLF);
		sb.append("q4MRNested.");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append(":-qBR.");
		sb.append(CRLF);
		sb.append("qBR :- cputime(T1), qBRNested, cputime(T2), T is T2 - T1," +
				"write('Time used: '),  write(T), write(' sec'), nl.");
		sb.append(CRLF);
		sb.append(CRLF);
		sb.append("qBRNested :- nl,write('Molecules with a benzene ring:'),nl,abolish_all_tables, " +
				"hasBenzeneRing(X), write(X), nl, fail.");
		sb.append(CRLF);
		sb.append("qBRNested.");
		sb.append(CRLF);
		
		return sb.toString();		
	}
}
