package uk.ac.ox.cs.krr.chebiclassifier;

import java.util.ArrayList;

public class XSBRule {
	
	private Atom m_headAtom;
    private ArrayList<Atom> m_bodyAtoms;
    
    public XSBRule(Atom headAtom,ArrayList<Atom> bodyAtoms){
		m_headAtom=headAtom;
		m_bodyAtoms=bodyAtoms;
	}
	
	public Atom getHeadAtom(){
		return this.m_headAtom;
	}
	
	public ArrayList<Atom> getBodyAtoms(){
		return this.m_bodyAtoms;
	}
	
	//it converts an xsb rule into a string
	public String getXSBSyntaxRule(){
		StringBuffer buffer=new StringBuffer();
        buffer.append(m_headAtom.getTextRepresentation());
        if (!m_bodyAtoms.isEmpty()){
        	buffer.append(" :- ");        
            for (Atom bodyAtom:m_bodyAtoms) {
            	buffer.append(bodyAtom.getTextRepresentation());
            	buffer.append(",");
			}
			buffer.deleteCharAt(buffer.length()-1);
        }        
        buffer.append(".");
        return buffer.toString();
	}
}
