package uk.ac.ox.cs.krr.chebiclassifier;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class XSBRulesGenerator {
	
	//given a description graph it returns its translation into LP rules	
	public Set<XSBRule>  produceAxiomRules(DescriptionGraph descriptionGraph){
		Set<XSBRule> rules=new LinkedHashSet<XSBRule>();
		rules.add(descriptionGraph.produceStartRule());
		rules.addAll(descriptionGraph.produceLayoutRules());
		rules.add(descriptionGraph.produceMoleculeRule());
		rules.add(descriptionGraph.produceMoleculeFact());
		return rules;
	}
	
	public Set<XSBRule>  produceCycleDetectionRules(ArrayList<DescriptionGraph> dgsToTest,GraphOrdering go){
		Set<XSBRule> rules=new LinkedHashSet<XSBRule>();
		for (DescriptionGraph dgl:dgsToTest){
			for (DescriptionGraph dgr:dgsToTest){
				Pair<DescriptionGraph,DescriptionGraph> pair=new Pair<DescriptionGraph,DescriptionGraph>(dgl,dgr);
				if (!(go.getImplicationPairs()).contains(pair)){
				rules.addAll(producePairCycleDetectionRules(pair));
				}
			}
		}
		return rules;
	}
	
	public Set<XSBRule> producePairCycleDetectionRules(Pair<DescriptionGraph,DescriptionGraph> pairDGs){
		Set<XSBRule> rules=new LinkedHashSet<XSBRule>();
		StringBuffer sb=new StringBuffer();
		ArrayList<String> headAtomTerms=new ArrayList<String>();
		Atom headAtom=new Atom("cycle",headAtomTerms);
		DescriptionGraph ldg=pairDGs.getLeft();
		DescriptionGraph rdg=pairDGs.getRight();
				
		for (int i=1; i<(ldg.getNodes()).size(); i++){
			ArrayList<Atom> bodyAtoms=new ArrayList<Atom>();
			bodyAtoms.add(ldg.produceGraphAtom(false));
			sb.append("Y");
			sb.append(i);
			bodyAtoms.add(rdg.produceStartAtom(sb.toString()));
	    	clearBuffer(sb);
	    	rules.add(new XSBRule(headAtom,bodyAtoms));
	    }
		
		return rules;
	}
	
	public StringBuffer clearBuffer(StringBuffer sb){
		return sb.delete(0,sb.length());
	}

}
