package uk.ac.ox.cs.krr.dlvstructured;

import java.util.ArrayList;

/* This class is a data structure for dlv rules. The fields include the head atom of the 
 * rule and a list of the body atoms. There is a method for getting a string representation
 * of the rule.
*/
public class DLVRule {

	private Atom m_headAtom;
    private ArrayList<Atom> m_bodyAtoms;
    private ArrayList<Atom> m_negativeBodyAtoms;
    
    public DLVRule(Atom headAtom,ArrayList<Atom> bodyAtoms){
		m_headAtom=headAtom;
		m_bodyAtoms=bodyAtoms;
		m_negativeBodyAtoms=new ArrayList<Atom>();
	}
    
    public DLVRule(Atom headAtom,ArrayList<Atom> bodyAtoms,ArrayList<Atom> negativeBodyAtoms){
		m_headAtom=headAtom;
		m_bodyAtoms=bodyAtoms;
		m_negativeBodyAtoms=negativeBodyAtoms;
	}
	
	public Atom getHeadAtom(){
		return this.m_headAtom;
	}
	
	public ArrayList<Atom> getBodyAtoms(){
		return this.m_bodyAtoms;
	}
	
	public ArrayList<Atom> getNegativeBodyAtoms(){
		return this.m_negativeBodyAtoms;
	}
	
	//it converts an DLV rule into a string
	public String getDLVSyntaxRule(){
		StringBuffer buffer=new StringBuffer();
        buffer.append(m_headAtom.getTextRepresentation());
        if (!m_bodyAtoms.isEmpty()){
        	buffer.append(" :- ");        
            for (Atom bodyAtom:m_bodyAtoms) {
            	buffer.append(bodyAtom.getTextRepresentation());
            	buffer.append(",");
			}
			buffer.deleteCharAt(buffer.length()-1);
        }
        if (!m_negativeBodyAtoms.isEmpty()){
        	buffer.append(",");        
            for (Atom negativeBodyAtom:m_negativeBodyAtoms) {
            	buffer.append("not ");
            	buffer.append(negativeBodyAtom.getTextRepresentation());
            	buffer.append(",");
			}
			buffer.deleteCharAt(buffer.length()-1);
        }
        buffer.append(".");
        return buffer.toString();
	}

}
